"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = getRequestType;
const documents_js_1 = require("./extensions/documents.js");
const fonts_js_1 = require("./extensions/fonts.js");
const images_js_1 = require("./extensions/images.js");
const medias_js_1 = require("./extensions/medias.js");
const scripts_js_1 = require("./extensions/scripts.js");
const stylesheets_js_1 = require("./extensions/stylesheets.js");
const extname_js_1 = require("./extname.js");
function getRequestType(url) {
    const ext = (0, extname_js_1.extname)(url);
    // Images
    if (images_js_1.EXTENSIONS.has(ext) ||
        url.startsWith('data:image/') ||
        url.startsWith('https://frog.wix.com/bt')) {
        return 'image';
    }
    // Medias
    if (medias_js_1.EXTENSIONS.has(ext) ||
        url.startsWith('data:audio/') ||
        url.startsWith('data:video/')) {
        return 'media';
    }
    // Stylesheets
    if (stylesheets_js_1.EXTENSIONS.has(ext) || url.startsWith('data:text/css')) {
        return 'stylesheet';
    }
    // Scripts
    if (scripts_js_1.EXTENSIONS.has(ext) ||
        (url.startsWith('data:') &&
            (url.startsWith('data:application/ecmascript') ||
                url.startsWith('data:application/javascript') ||
                url.startsWith('data:application/x-ecmascript') ||
                url.startsWith('data:application/x-javascript') ||
                url.startsWith('data:text/ecmascript') ||
                url.startsWith('data:text/javascript') ||
                url.startsWith('data:text/javascript1.0') ||
                url.startsWith('data:text/javascript1.1') ||
                url.startsWith('data:text/javascript1.2') ||
                url.startsWith('data:text/javascript1.3') ||
                url.startsWith('data:text/javascript1.4') ||
                url.startsWith('data:text/javascript1.5') ||
                url.startsWith('data:text/jscript') ||
                url.startsWith('data:text/livescript') ||
                url.startsWith('data:text/x-ecmascript') ||
                url.startsWith('data:text/x-javascript'))) ||
        url.startsWith('https://maps.googleapis.com/maps/api/js') ||
        url.startsWith('https://www.googletagmanager.com/gtag/js')) {
        return 'script';
    }
    // Documents
    if (documents_js_1.EXTENSIONS.has(ext) ||
        url.startsWith('data:text/html') ||
        url.startsWith('data:application/xhtml') ||
        url.startsWith('https://www.youtube.com/embed/') ||
        url.startsWith('https://www.google.com/gen_204')) {
        return 'document';
    }
    // Fonts
    if (fonts_js_1.EXTENSIONS.has(ext) || url.startsWith('data:font/')) {
        return 'font';
    }
    return 'other';
}
//# sourceMappingURL=index.js.map