# Installation
> `npm install --save @types/pdf-parse`

# Summary
This package contains type definitions for pdf-parse (https://gitlab.com/autokent/pdf-parse).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/pdf-parse.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/pdf-parse/index.d.ts)
````ts
export = PdfParse;

declare function PdfParse(dataBuffer: Buffer, options?: PdfParse.Options): Promise<PdfParse.Result>;

declare namespace PdfParse {
    type Version = "default" | "v1.9.426" | "v1.10.100" | "v1.10.88" | "v2.0.550";
    interface Result {
        numpages: number;
        numrender: number;
        info: any;
        metadata: any;
        version: Version;
        text: string;
    }
    interface Options {
        pagerender?: ((pageData: any) => string) | undefined;
        max?: number | undefined;
        version?: Version | undefined;
    }
}

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: none

# Credits
These definitions were written by [Philipp Katz](https://github.com/qqilihq).
